<?php
require_once 'config.php';
require_once 'header.php';
?>

<div class="blog-section py-5">
    <h1 class="text-center mb-5">المدونة</h1>
    
    <div class="row">
        <div class="col-md-8">
            <div class="card mb-4">
                <div class="card-body">
                    <h2 class="card-title">كيفية استخدام الرسائل القصيرة في التسويق</h2>
                    <p class="text-muted">نشر في: 15 مارس 2024</p>
                    <p class="card-text">تعتبر الرسائل القصيرة من أهم وسائل التسويق في العصر الحديث. في هذا المقال، سنتعرف على كيفية استخدام الرسائل القصيرة بشكل فعال في التسويق وكيفية تحقيق أفضل النتائج.</p>
                    <a href="#" class="btn btn-primary">اقرأ المزيد</a>
                </div>
            </div>
            
            <div class="card mb-4">
                <div class="card-body">
                    <h2 class="card-title">أفضل ممارسات إرسال الرسائل القصيرة</h2>
                    <p class="text-muted">نشر في: 10 مارس 2024</p>
                    <p class="card-text">هناك العديد من الممارسات التي يجب اتباعها عند إرسال الرسائل القصيرة لضمان فعاليتها وتحقيق أفضل النتائج. تعرف على هذه الممارسات في هذا المقال.</p>
                    <a href="#" class="btn btn-primary">اقرأ المزيد</a>
                </div>
            </div>
            
            <div class="card mb-4">
                <div class="card-body">
                    <h2 class="card-title">كيفية زيادة معدل استجابة الرسائل القصيرة</h2>
                    <p class="text-muted">نشر في: 5 مارس 2024</p>
                    <p class="card-text">زيادة معدل استجابة الرسائل القصيرة هو هدف كل مسوق. في هذا المقال، سنتعرف على أفضل الطرق لزيادة معدل الاستجابة وتحقيق نتائج أفضل.</p>
                    <a href="#" class="btn btn-primary">اقرأ المزيد</a>
                </div>
            </div>
        </div>
        
        <div class="col-md-4">
            <div class="card mb-4">
                <div class="card-body">
                    <h3 class="card-title">الأقسام</h3>
                    <ul class="list-unstyled">
                        <li><a href="#" class="text-decoration-none">تسويق</a></li>
                        <li><a href="#" class="text-decoration-none">تقنية</a></li>
                        <li><a href="#" class="text-decoration-none">أخبار</a></li>
                        <li><a href="#" class="text-decoration-none">نصائح</a></li>
                    </ul>
                </div>
            </div>
            
            <div class="card mb-4">
                <div class="card-body">
                    <h3 class="card-title">آخر المقالات</h3>
                    <ul class="list-unstyled">
                        <li class="mb-2">
                            <a href="#" class="text-decoration-none">كيفية استخدام الرسائل القصيرة في التسويق</a>
                            <small class="d-block text-muted">15 مارس 2024</small>
                        </li>
                        <li class="mb-2">
                            <a href="#" class="text-decoration-none">أفضل ممارسات إرسال الرسائل القصيرة</a>
                            <small class="d-block text-muted">10 مارس 2024</small>
                        </li>
                        <li class="mb-2">
                            <a href="#" class="text-decoration-none">كيفية زيادة معدل استجابة الرسائل القصيرة</a>
                            <small class="d-block text-muted">5 مارس 2024</small>
                        </li>
                    </ul>
                </div>
            </div>
            
            <div class="card">
                <div class="card-body">
                    <h3 class="card-title">الوسوم</h3>
                    <div class="d-flex flex-wrap gap-2">
                        <a href="#" class="badge bg-primary text-decoration-none">تسويق</a>
                        <a href="#" class="badge bg-primary text-decoration-none">رسائل قصيرة</a>
                        <a href="#" class="badge bg-primary text-decoration-none">تقنية</a>
                        <a href="#" class="badge bg-primary text-decoration-none">أعمال</a>
                        <a href="#" class="badge bg-primary text-decoration-none">تطوير</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
console.log('groupedServices:', <?= json_encode($groupedServices, JSON_UNESCAPED_UNICODE); ?>);
</script>

<?php require_once 'footer.php'; ?> 